
import numpy as np
import math

def f(x):
    return np.sin(x) + math.tanh(x)

x_values = np.linspace(-128, 128, num=1000)
y_values = [f(x) for x in x_values]

# Plotting the function for visualization
import matplotlib.pyplot as plt

plt.plot(x_values, y_values)
plt.xlabel('x')
plt.ylabel('f(x)')
plt.title('Graph of f(x)')
plt.show()
