
import numpy as np

def f(x):
    # Approximation of f(x) behavior
    return np.sin(x) * np.exp(-x)

# Testing the function on a range of values
x_values = np.linspace(-128, 128, 100)
output_values = f(x_values)

# Plotting the function behavior
import matplotlib.pyplot as plt

plt.plot(x_values, output_values)
plt.xlabel('x')
plt.ylabel('f(x)')
plt.title('Approximation of f(x) Behavior')
plt.show()
