
import numpy as np
import matplotlib.pyplot as plt

# Define the function f(x)
def f(x):
    # Add your interpretation of the function based on the experiments here
    pass

# Define the interval where the function displays unexpected behavior
# Update the lower_bound and upper_bound with the experimental values
lower_bound = -10
upper_bound = 10

# Generate input values within the interval
x_values = np.linspace(lower_bound, upper_bound, 100)

# Calculate the corresponding output values using the function
y_values = f(x_values)

# Apply a polynomial regression to approximate the function's behavior
degree = 2
coefficients = np.polyfit(x_values, y_values, degree)

# Define the polynomial function with the obtained coefficients
def approximated_f(x):
    return np.polyval(coefficients, x)

# Plot the actual function and the approximated function
plt.plot(x_values, y_values, label='Actual f(x)')
plt.plot(x_values, approximated_f(x_values), label='Approximated f(x)')
plt.xlabel('x')
plt.ylabel('f(x)')
plt.title('Approximation of f(x)')
plt.legend()
plt.show()
