
import numpy as np
from sklearn.preprocessing import PolynomialFeatures
from sklearn.linear_model import LinearRegression

# Input values
X = np.array([-128, -100, -50, 0, 50, 100, 128]).reshape(-1, 1)

# Output values
y = np.array([-0.2561162865825162, -0.024011328698640533, -0.6568337709468182, -0.4683633918897423, 0.1691851688651409, 1.2691905207761156, 1.3365979557413024])

# Polynomial regression
poly_features = PolynomialFeatures(degree=3)
X_poly = poly_features.fit_transform(X)

model = LinearRegression()
model.fit(X_poly, y)

# Predicting output for a given input value x
def f(x):
    x_poly = poly_features.transform(np.array([x]).reshape(-1, 1))
    return model.predict(x_poly)[0]

# Testing the approximate behavior of f(x)
print(f(-128))  # Approximate output: -0.2561162865825162
print(f(128))  # Approximate output: 1.336597955741299

