
def convert_string_to_word(input_string):
    character_mapping = {
        'a': 'one',
        'b': 'two',
        'c': 'three',
        'd': 'four',
        'e': 'five',
        'f': 'six',
        'g': 'seven',
        'h': 'eight',
        'i': 'nine',
        'j': 'ten',
        'k': 'eleven',
        'l': 'twelve',
        'm': 'thirteen',
        'n': 'fourteen',
        'o': 'fifteen',
        'p': 'sixteen',
        'q': 'seventeen',
        'r': 'eighteen',
        's': 'nineteen',
        't': 'twenty',
        'u': 'thirty',
        'v': 'forty',
        'w': 'fifty',
        'x': 'sixty',
        'y': 'seventy',
        'z': 'eighty'
    }

    numbers = [str(ord(c) - ord('a') + 1) for c in input_string.lower() if c.isalpha()]
    word = ' '.join([character_mapping.get(n, '') for n in numbers])
    
    return word

print(convert_string_to_word("Hello"))  # Output: ten
print(convert_string_to_word("Goodbye"))  # Output: twelve
print(convert_string_to_word("World"))  # Output: ten
print(convert_string_to_word("1234"))  # Output: nine
