
def roman_numeral(num):
    val = [1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1]
    symbols = ["M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"]

    roman = ""
    for i in range(len(val)):
        count = int(num / val[i])
        roman += symbols[i] * count
        num -= val[i] * count

    return roman

def number_to_words(num):
    words = ["zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"]
    return words[num]

def approximate_function(s):
    vowels = "aeiou"
    if s.isalpha():
        count = sum([1 for c in s if c.lower() in vowels])
        return roman_numeral(count)
    elif s.isdigit():
        count = sum([int(c) for c in s]) // 3
        return number_to_words(count) 
