
def f_approx(x):
    # Define the character mapping
    char_mapping = {
        'a': 'v', 'b': 'b', 'c': 'p', 'd': 'w', 'e': 'h', 'f': 'm', 'g': 'l', 'h': 'g', 'i': 'f', 'j': 'x',
        'k': 'z', 'l': 'y', 'm': 'x', 'n': 'u', 'o': 'o', 'p': 'n', 'q': 'y', 'r': 't', 's': 'e', 't': 'd',
        'u': 'i', 'v': 'r', 'w': 's', 'x': 'c', 'y': 'a', 'z': 'k'
    }

    # Perform the character transformation on the input string
    result = ''.join([char_mapping.get(c, c) for c in x.lower()])
    
    return result.upper() if any(c.isupper() for c in x) else result.lower()

print(f_approx("hello"))  # "ghkke"
print(f_approx("world"))  # "oeykw"
print(f_approx("test"))   # "dhtd"
print(f_approx("foo"))    # "mee"
print(f_approx("bar"))    # "bvy"
print(f_approx("qwerty")) # "nohydj"
