
def transform(char):
    lower_consonants = "bcdfghjklmnpqrstvwxyz"
    upper_consonants = "BCDFGHJKLMNPQRSTVWXYZ"
    lower_vowel_map = {'a': 'z', 'e': '{', 'i': '', 'o': '¨', 'u': ''}
    upper_vowel_map = {'A': 'Z', 'E': '{', 'I': 'Ë', 'O': '¨', 'U': ''}

    if char in lower_consonants:
        return lower_consonants[(lower_consonants.index(char) + 1) % len(lower_consonants)]
    elif char in upper_consonants:
        return upper_consonants[(upper_consonants.index(char) + 1) % len(upper_consonants)]
    elif char in lower_vowel_map:
        return lower_vowel_map[char]
    elif char in upper_vowel_map:
        return upper_vowel_map[char]
    else:
        return char

def f(input_string):
    return ''.join(transform(char) for char in input_string)

