
def count_characters(s):
    s = s.lower()
    counts = {c: 0 for c in set(s) if c.isalnum()}

    for c in s:
        if c.isalnum():
            counts[c] += 1

    spelled_out_counts = {
        'zero': 0, 'one': 1, 'two': 2, 'three': 3, 'four': 4,
        'five': 5, 'six': 6, 'seven': 7, 'eight': 8, 'nine': 9,
    }
    
    output = []
    for c in s:
        if c.isalnum():
            for word, count in spelled_out_counts.items():
                if count == counts[c]:
                    output.append(word)

    return " ".join(output)

input_str = 'YourInputHere'
print(count_characters(input_str))
